<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/tracing/trace.proto

namespace Google\Tracing\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A span represents a single operation within a trace. Spans can be nested
 * and form a trace tree. Often, a trace contains a root span that describes the
 * end-to-end latency and, optionally, one or more subspans for
 * its sub-operations. Spans do not need to be contiguous. There may be gaps
 * between spans in a trace.
 *
 * Generated from protobuf message <code>google.tracing.v1.Span</code>
 */
class Span extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace.
     *
     * Generated from protobuf field <code>fixed64 id = 1;</code>
     */
    private $id = 0;
    /**
     * Name of the span. The span name is sanitized and displayed in the
     * Stackdriver Trace tool in the {% dynamic print site_values.console_name %}.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     */
    private $name = '';
    /**
     * ID of parent span. 0 or missing if this is a root span.
     *
     * Generated from protobuf field <code>fixed64 parent_id = 3;</code>
     */
    private $parent_id = 0;
    /**
     * Local machine clock in nanoseconds from the UNIX epoch,
     * at which span execution started.
     * On the server side these are the times when the server application
     * handler starts running.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp local_start_time = 4;</code>
     */
    private $local_start_time = null;
    /**
     * Local machine clock in nanoseconds from the UNIX epoch,
     * at which span execution ended.
     * On the server side these are the times when the server application
     * handler finishes running.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp local_end_time = 5;</code>
     */
    private $local_end_time = null;
    /**
     * Properties of a span. Labels at the span level.
     * E.g.
     * "/instance_id": "my-instance"
     * "/zone": "us-central1-a"
     * "/grpc/peer_address": "ip:port" (dns, etc.)
     * "/grpc/deadline": "Duration"
     * "/http/user_agent"
     * "/http/request_bytes": 300
     * "/http/response_bytes": 1200
     * "/http/url": google.com/apis
     * "/pid"
     * "abc.com/mylabel": "my label value"
     *
     * Generated from protobuf field <code>map<string, .google.tracing.v1.LabelValue> labels = 6;</code>
     */
    private $labels;
    /**
     * Stack trace captured at the start of the span. This is optional.
     *
     * Generated from protobuf field <code>.google.tracing.v1.StackTrace stack_trace = 7;</code>
     */
    private $stack_trace = null;
    /**
     * A collection of time-stamped events.
     *
     * Generated from protobuf field <code>repeated .google.tracing.v1.Span.TimeEvent time_events = 8;</code>
     */
    private $time_events;
    /**
     * A collection of links.
     *
     * Generated from protobuf field <code>repeated .google.tracing.v1.Span.Link links = 9;</code>
     */
    private $links;
    /**
     * The final status of the Span. This is optional.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 10;</code>
     */
    private $status = null;
    /**
     * True if this Span has a remote parent (is an RPC server Span).
     *
     * Generated from protobuf field <code>bool has_remote_parent = 11;</code>
     */
    private $has_remote_parent = false;

    public function __construct() {
        \GPBMetadata\Google\Tracing\Trace::initOnce();
        parent::__construct();
    }

    /**
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace.
     *
     * Generated from protobuf field <code>fixed64 id = 1;</code>
     * @return int|string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace.
     *
     * Generated from protobuf field <code>fixed64 id = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Name of the span. The span name is sanitized and displayed in the
     * Stackdriver Trace tool in the {% dynamic print site_values.console_name %}.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the span. The span name is sanitized and displayed in the
     * Stackdriver Trace tool in the {% dynamic print site_values.console_name %}.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * ID of parent span. 0 or missing if this is a root span.
     *
     * Generated from protobuf field <code>fixed64 parent_id = 3;</code>
     * @return int|string
     */
    public function getParentId()
    {
        return $this->parent_id;
    }

    /**
     * ID of parent span. 0 or missing if this is a root span.
     *
     * Generated from protobuf field <code>fixed64 parent_id = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setParentId($var)
    {
        GPBUtil::checkUint64($var);
        $this->parent_id = $var;

        return $this;
    }

    /**
     * Local machine clock in nanoseconds from the UNIX epoch,
     * at which span execution started.
     * On the server side these are the times when the server application
     * handler starts running.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp local_start_time = 4;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLocalStartTime()
    {
        return $this->local_start_time;
    }

    /**
     * Local machine clock in nanoseconds from the UNIX epoch,
     * at which span execution started.
     * On the server side these are the times when the server application
     * handler starts running.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp local_start_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLocalStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->local_start_time = $var;

        return $this;
    }

    /**
     * Local machine clock in nanoseconds from the UNIX epoch,
     * at which span execution ended.
     * On the server side these are the times when the server application
     * handler finishes running.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp local_end_time = 5;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLocalEndTime()
    {
        return $this->local_end_time;
    }

    /**
     * Local machine clock in nanoseconds from the UNIX epoch,
     * at which span execution ended.
     * On the server side these are the times when the server application
     * handler finishes running.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp local_end_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLocalEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->local_end_time = $var;

        return $this;
    }

    /**
     * Properties of a span. Labels at the span level.
     * E.g.
     * "/instance_id": "my-instance"
     * "/zone": "us-central1-a"
     * "/grpc/peer_address": "ip:port" (dns, etc.)
     * "/grpc/deadline": "Duration"
     * "/http/user_agent"
     * "/http/request_bytes": 300
     * "/http/response_bytes": 1200
     * "/http/url": google.com/apis
     * "/pid"
     * "abc.com/mylabel": "my label value"
     *
     * Generated from protobuf field <code>map<string, .google.tracing.v1.LabelValue> labels = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Properties of a span. Labels at the span level.
     * E.g.
     * "/instance_id": "my-instance"
     * "/zone": "us-central1-a"
     * "/grpc/peer_address": "ip:port" (dns, etc.)
     * "/grpc/deadline": "Duration"
     * "/http/user_agent"
     * "/http/request_bytes": 300
     * "/http/response_bytes": 1200
     * "/http/url": google.com/apis
     * "/pid"
     * "abc.com/mylabel": "my label value"
     *
     * Generated from protobuf field <code>map<string, .google.tracing.v1.LabelValue> labels = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Tracing\V1\LabelValue::class);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Stack trace captured at the start of the span. This is optional.
     *
     * Generated from protobuf field <code>.google.tracing.v1.StackTrace stack_trace = 7;</code>
     * @return \Google\Tracing\V1\StackTrace
     */
    public function getStackTrace()
    {
        return $this->stack_trace;
    }

    /**
     * Stack trace captured at the start of the span. This is optional.
     *
     * Generated from protobuf field <code>.google.tracing.v1.StackTrace stack_trace = 7;</code>
     * @param \Google\Tracing\V1\StackTrace $var
     * @return $this
     */
    public function setStackTrace($var)
    {
        GPBUtil::checkMessage($var, \Google\Tracing\V1\StackTrace::class);
        $this->stack_trace = $var;

        return $this;
    }

    /**
     * A collection of time-stamped events.
     *
     * Generated from protobuf field <code>repeated .google.tracing.v1.Span.TimeEvent time_events = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTimeEvents()
    {
        return $this->time_events;
    }

    /**
     * A collection of time-stamped events.
     *
     * Generated from protobuf field <code>repeated .google.tracing.v1.Span.TimeEvent time_events = 8;</code>
     * @param \Google\Tracing\V1\Span_TimeEvent[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTimeEvents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Tracing\V1\Span_TimeEvent::class);
        $this->time_events = $arr;

        return $this;
    }

    /**
     * A collection of links.
     *
     * Generated from protobuf field <code>repeated .google.tracing.v1.Span.Link links = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLinks()
    {
        return $this->links;
    }

    /**
     * A collection of links.
     *
     * Generated from protobuf field <code>repeated .google.tracing.v1.Span.Link links = 9;</code>
     * @param \Google\Tracing\V1\Span_Link[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Tracing\V1\Span_Link::class);
        $this->links = $arr;

        return $this;
    }

    /**
     * The final status of the Span. This is optional.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 10;</code>
     * @return \Google\Rpc\Status
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * The final status of the Span. This is optional.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 10;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * True if this Span has a remote parent (is an RPC server Span).
     *
     * Generated from protobuf field <code>bool has_remote_parent = 11;</code>
     * @return bool
     */
    public function getHasRemoteParent()
    {
        return $this->has_remote_parent;
    }

    /**
     * True if this Span has a remote parent (is an RPC server Span).
     *
     * Generated from protobuf field <code>bool has_remote_parent = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setHasRemoteParent($var)
    {
        GPBUtil::checkBool($var);
        $this->has_remote_parent = $var;

        return $this;
    }

}

