<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/variants.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A variant represents a change in DNA sequence relative to a reference
 * sequence. For example, a variant could represent a SNP or an insertion.
 * Variants belong to a variant set.
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 * Each of the calls on a variant represent a determination of genotype with
 * respect to that variant. For example, a call might assign probability of 0.32
 * to the occurrence of a SNP named rs1234 in a sample named NA12345. A call
 * belongs to a call set, which contains related calls typically from one
 * sample.
 *
 * Generated from protobuf message <code>google.genomics.v1.Variant</code>
 */
class Variant extends \Google\Protobuf\Internal\Message
{
    /**
     * The ID of the variant set this variant belongs to.
     *
     * Generated from protobuf field <code>string variant_set_id = 15;</code>
     */
    private $variant_set_id = '';
    /**
     * The server-generated variant ID, unique across all variants.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     */
    private $id = '';
    /**
     * Names for the variant, for example a RefSNP ID.
     *
     * Generated from protobuf field <code>repeated string names = 3;</code>
     */
    private $names;
    /**
     * The date this variant was created, in milliseconds from the epoch.
     *
     * Generated from protobuf field <code>int64 created = 12;</code>
     */
    private $created = 0;
    /**
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     *
     * Generated from protobuf field <code>string reference_name = 14;</code>
     */
    private $reference_name = '';
    /**
     * The position at which this variant occurs (0-based).
     * This corresponds to the first base of the string of reference bases.
     *
     * Generated from protobuf field <code>int64 start = 16;</code>
     */
    private $start = 0;
    /**
     * The end position (0-based) of this variant. This corresponds to the first
     * base after the last base in the reference allele. So, the length of
     * the reference allele is (end - start). This is useful for variants
     * that don't explicitly give alternate bases, for example large deletions.
     *
     * Generated from protobuf field <code>int64 end = 13;</code>
     */
    private $end = 0;
    /**
     * The reference bases for this variant. They start at the given
     * position.
     *
     * Generated from protobuf field <code>string reference_bases = 6;</code>
     */
    private $reference_bases = '';
    /**
     * The bases that appear instead of the reference bases.
     *
     * Generated from protobuf field <code>repeated string alternate_bases = 7;</code>
     */
    private $alternate_bases;
    /**
     * A measure of how likely this variant is to be real.
     * A higher value is better.
     *
     * Generated from protobuf field <code>double quality = 8;</code>
     */
    private $quality = 0.0;
    /**
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     *
     * Generated from protobuf field <code>repeated string filter = 9;</code>
     */
    private $filter;
    /**
     * A map of additional variant information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 10;</code>
     */
    private $info;
    /**
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    private $calls;

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\Variants::initOnce();
        parent::__construct();
    }

    /**
     * The ID of the variant set this variant belongs to.
     *
     * Generated from protobuf field <code>string variant_set_id = 15;</code>
     * @return string
     */
    public function getVariantSetId()
    {
        return $this->variant_set_id;
    }

    /**
     * The ID of the variant set this variant belongs to.
     *
     * Generated from protobuf field <code>string variant_set_id = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setVariantSetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->variant_set_id = $var;

        return $this;
    }

    /**
     * The server-generated variant ID, unique across all variants.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The server-generated variant ID, unique across all variants.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Names for the variant, for example a RefSNP ID.
     *
     * Generated from protobuf field <code>repeated string names = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNames()
    {
        return $this->names;
    }

    /**
     * Names for the variant, for example a RefSNP ID.
     *
     * Generated from protobuf field <code>repeated string names = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->names = $arr;

        return $this;
    }

    /**
     * The date this variant was created, in milliseconds from the epoch.
     *
     * Generated from protobuf field <code>int64 created = 12;</code>
     * @return int|string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * The date this variant was created, in milliseconds from the epoch.
     *
     * Generated from protobuf field <code>int64 created = 12;</code>
     * @param int|string $var
     * @return $this
     */
    public function setCreated($var)
    {
        GPBUtil::checkInt64($var);
        $this->created = $var;

        return $this;
    }

    /**
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     *
     * Generated from protobuf field <code>string reference_name = 14;</code>
     * @return string
     */
    public function getReferenceName()
    {
        return $this->reference_name;
    }

    /**
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     *
     * Generated from protobuf field <code>string reference_name = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setReferenceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->reference_name = $var;

        return $this;
    }

    /**
     * The position at which this variant occurs (0-based).
     * This corresponds to the first base of the string of reference bases.
     *
     * Generated from protobuf field <code>int64 start = 16;</code>
     * @return int|string
     */
    public function getStart()
    {
        return $this->start;
    }

    /**
     * The position at which this variant occurs (0-based).
     * This corresponds to the first base of the string of reference bases.
     *
     * Generated from protobuf field <code>int64 start = 16;</code>
     * @param int|string $var
     * @return $this
     */
    public function setStart($var)
    {
        GPBUtil::checkInt64($var);
        $this->start = $var;

        return $this;
    }

    /**
     * The end position (0-based) of this variant. This corresponds to the first
     * base after the last base in the reference allele. So, the length of
     * the reference allele is (end - start). This is useful for variants
     * that don't explicitly give alternate bases, for example large deletions.
     *
     * Generated from protobuf field <code>int64 end = 13;</code>
     * @return int|string
     */
    public function getEnd()
    {
        return $this->end;
    }

    /**
     * The end position (0-based) of this variant. This corresponds to the first
     * base after the last base in the reference allele. So, the length of
     * the reference allele is (end - start). This is useful for variants
     * that don't explicitly give alternate bases, for example large deletions.
     *
     * Generated from protobuf field <code>int64 end = 13;</code>
     * @param int|string $var
     * @return $this
     */
    public function setEnd($var)
    {
        GPBUtil::checkInt64($var);
        $this->end = $var;

        return $this;
    }

    /**
     * The reference bases for this variant. They start at the given
     * position.
     *
     * Generated from protobuf field <code>string reference_bases = 6;</code>
     * @return string
     */
    public function getReferenceBases()
    {
        return $this->reference_bases;
    }

    /**
     * The reference bases for this variant. They start at the given
     * position.
     *
     * Generated from protobuf field <code>string reference_bases = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setReferenceBases($var)
    {
        GPBUtil::checkString($var, True);
        $this->reference_bases = $var;

        return $this;
    }

    /**
     * The bases that appear instead of the reference bases.
     *
     * Generated from protobuf field <code>repeated string alternate_bases = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAlternateBases()
    {
        return $this->alternate_bases;
    }

    /**
     * The bases that appear instead of the reference bases.
     *
     * Generated from protobuf field <code>repeated string alternate_bases = 7;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAlternateBases($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->alternate_bases = $arr;

        return $this;
    }

    /**
     * A measure of how likely this variant is to be real.
     * A higher value is better.
     *
     * Generated from protobuf field <code>double quality = 8;</code>
     * @return float
     */
    public function getQuality()
    {
        return $this->quality;
    }

    /**
     * A measure of how likely this variant is to be real.
     * A higher value is better.
     *
     * Generated from protobuf field <code>double quality = 8;</code>
     * @param float $var
     * @return $this
     */
    public function setQuality($var)
    {
        GPBUtil::checkDouble($var);
        $this->quality = $var;

        return $this;
    }

    /**
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     *
     * Generated from protobuf field <code>repeated string filter = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     *
     * Generated from protobuf field <code>repeated string filter = 9;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFilter($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->filter = $arr;

        return $this;
    }

    /**
     * A map of additional variant information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 10;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getInfo()
    {
        return $this->info;
    }

    /**
     * A map of additional variant information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 10;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setInfo($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\ListValue::class);
        $this->info = $arr;

        return $this;
    }

    /**
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCalls()
    {
        return $this->calls;
    }

    /**
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     * @param \Google\Genomics\V1\VariantCall[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCalls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Genomics\V1\VariantCall::class);
        $this->calls = $arr;

        return $this;
    }

}

