<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/variants.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The variant data export request.
 *
 * Generated from protobuf message <code>google.genomics.v1.ExportVariantSetRequest</code>
 */
class ExportVariantSetRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the variant set that contains variant data which
     * should be exported. The caller must have READ access to this variant set.
     *
     * Generated from protobuf field <code>string variant_set_id = 1;</code>
     */
    private $variant_set_id = '';
    /**
     * If provided, only variant call information from the specified call sets
     * will be exported. By default all variant calls are exported.
     *
     * Generated from protobuf field <code>repeated string call_set_ids = 2;</code>
     */
    private $call_set_ids;
    /**
     * Required. The Google Cloud project ID that owns the destination
     * BigQuery dataset. The caller must have WRITE access to this project.  This
     * project will also own the resulting export job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     */
    private $project_id = '';
    /**
     * The format for the exported data.
     *
     * Generated from protobuf field <code>.google.genomics.v1.ExportVariantSetRequest.Format format = 4;</code>
     */
    private $format = 0;
    /**
     * Required. The BigQuery dataset to export data to. This dataset must already
     * exist. Note that this is distinct from the Genomics concept of "dataset".
     *
     * Generated from protobuf field <code>string bigquery_dataset = 5;</code>
     */
    private $bigquery_dataset = '';
    /**
     * Required. The BigQuery table to export data to.
     * If the table doesn't exist, it will be created. If it already exists, it
     * will be overwritten.
     *
     * Generated from protobuf field <code>string bigquery_table = 6;</code>
     */
    private $bigquery_table = '';

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\Variants::initOnce();
        parent::__construct();
    }

    /**
     * Required. The ID of the variant set that contains variant data which
     * should be exported. The caller must have READ access to this variant set.
     *
     * Generated from protobuf field <code>string variant_set_id = 1;</code>
     * @return string
     */
    public function getVariantSetId()
    {
        return $this->variant_set_id;
    }

    /**
     * Required. The ID of the variant set that contains variant data which
     * should be exported. The caller must have READ access to this variant set.
     *
     * Generated from protobuf field <code>string variant_set_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setVariantSetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->variant_set_id = $var;

        return $this;
    }

    /**
     * If provided, only variant call information from the specified call sets
     * will be exported. By default all variant calls are exported.
     *
     * Generated from protobuf field <code>repeated string call_set_ids = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCallSetIds()
    {
        return $this->call_set_ids;
    }

    /**
     * If provided, only variant call information from the specified call sets
     * will be exported. By default all variant calls are exported.
     *
     * Generated from protobuf field <code>repeated string call_set_ids = 2;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCallSetIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->call_set_ids = $arr;

        return $this;
    }

    /**
     * Required. The Google Cloud project ID that owns the destination
     * BigQuery dataset. The caller must have WRITE access to this project.  This
     * project will also own the resulting export job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Required. The Google Cloud project ID that owns the destination
     * BigQuery dataset. The caller must have WRITE access to this project.  This
     * project will also own the resulting export job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * The format for the exported data.
     *
     * Generated from protobuf field <code>.google.genomics.v1.ExportVariantSetRequest.Format format = 4;</code>
     * @return int
     */
    public function getFormat()
    {
        return $this->format;
    }

    /**
     * The format for the exported data.
     *
     * Generated from protobuf field <code>.google.genomics.v1.ExportVariantSetRequest.Format format = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Genomics\V1\ExportVariantSetRequest_Format::class);
        $this->format = $var;

        return $this;
    }

    /**
     * Required. The BigQuery dataset to export data to. This dataset must already
     * exist. Note that this is distinct from the Genomics concept of "dataset".
     *
     * Generated from protobuf field <code>string bigquery_dataset = 5;</code>
     * @return string
     */
    public function getBigqueryDataset()
    {
        return $this->bigquery_dataset;
    }

    /**
     * Required. The BigQuery dataset to export data to. This dataset must already
     * exist. Note that this is distinct from the Genomics concept of "dataset".
     *
     * Generated from protobuf field <code>string bigquery_dataset = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setBigqueryDataset($var)
    {
        GPBUtil::checkString($var, True);
        $this->bigquery_dataset = $var;

        return $this;
    }

    /**
     * Required. The BigQuery table to export data to.
     * If the table doesn't exist, it will be created. If it already exists, it
     * will be overwritten.
     *
     * Generated from protobuf field <code>string bigquery_table = 6;</code>
     * @return string
     */
    public function getBigqueryTable()
    {
        return $this->bigquery_table;
    }

    /**
     * Required. The BigQuery table to export data to.
     * If the table doesn't exist, it will be created. If it already exists, it
     * will be overwritten.
     *
     * Generated from protobuf field <code>string bigquery_table = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setBigqueryTable($var)
    {
        GPBUtil::checkString($var, True);
        $this->bigquery_table = $var;

        return $this;
    }

}

