<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudtrace/v1/trace.proto

namespace Google\Cloud\Trace\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A span represents a single timed event within a trace. Spans can be nested
 * and form a trace tree. Often, a trace contains a root span that describes the
 * end-to-end latency of an operation and, optionally, one or more subspans for
 * its suboperations. Spans do not need to be contiguous. There may be gaps
 * between spans in a trace.
 *
 * Generated from protobuf message <code>google.devtools.cloudtrace.v1.TraceSpan</code>
 */
class TraceSpan extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace.
     *
     * Generated from protobuf field <code>fixed64 span_id = 1;</code>
     */
    private $span_id = 0;
    /**
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     *
     * Generated from protobuf field <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     */
    private $kind = 0;
    /**
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * {% dynamic print site_values.console_name %}.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     *
     * Generated from protobuf field <code>string name = 3;</code>
     */
    private $name = '';
    /**
     * Start time of the span in nanoseconds from the UNIX epoch.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    private $start_time = null;
    /**
     * End time of the span in nanoseconds from the UNIX epoch.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    private $end_time = null;
    /**
     * ID of the parent span, if any. Optional.
     *
     * Generated from protobuf field <code>fixed64 parent_span_id = 6;</code>
     */
    private $parent_span_id = 0;
    /**
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;

    public function __construct() {
        \GPBMetadata\Google\Devtools\Cloudtrace\V1\Trace::initOnce();
        parent::__construct();
    }

    /**
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace.
     *
     * Generated from protobuf field <code>fixed64 span_id = 1;</code>
     * @return int|string
     */
    public function getSpanId()
    {
        return $this->span_id;
    }

    /**
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace.
     *
     * Generated from protobuf field <code>fixed64 span_id = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSpanId($var)
    {
        GPBUtil::checkUint64($var);
        $this->span_id = $var;

        return $this;
    }

    /**
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     *
     * Generated from protobuf field <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     * @return int
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     *
     * Generated from protobuf field <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Trace\V1\TraceSpan_SpanKind::class);
        $this->kind = $var;

        return $this;
    }

    /**
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * {% dynamic print site_values.console_name %}.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     *
     * Generated from protobuf field <code>string name = 3;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * {% dynamic print site_values.console_name %}.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     *
     * Generated from protobuf field <code>string name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Start time of the span in nanoseconds from the UNIX epoch.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    /**
     * Start time of the span in nanoseconds from the UNIX epoch.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * End time of the span in nanoseconds from the UNIX epoch.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    /**
     * End time of the span in nanoseconds from the UNIX epoch.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * ID of the parent span, if any. Optional.
     *
     * Generated from protobuf field <code>fixed64 parent_span_id = 6;</code>
     * @return int|string
     */
    public function getParentSpanId()
    {
        return $this->parent_span_id;
    }

    /**
     * ID of the parent span, if any. Optional.
     *
     * Generated from protobuf field <code>fixed64 parent_span_id = 6;</code>
     * @param int|string $var
     * @return $this
     */
    public function setParentSpanId($var)
    {
        GPBUtil::checkUint64($var);
        $this->parent_span_id = $var;

        return $this;
    }

    /**
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

}

