<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/runtimeconfig/v1beta1/resources.proto

namespace Google\Cloud\RuntimeConfig\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Cardinality condition for the Waiter resource. A cardinality condition is
 * met when the number of variables under a specified path prefix reaches a
 * predefined number. For example, if you set a Cardinality condition where
 * the `path` is set to `/foo` and the number of paths is set to 2, the
 * following variables would meet the condition in a RuntimeConfig resource:
 * + `/foo/variable1 = "value1"`
 * + `/foo/variable2 = "value2"`
 * + `/bar/variable3 = "value3"`
 * It would not would not satisify the same condition with the `number` set to
 * 3, however, because there is only 2 paths that start with `/foo`.
 * Cardinality conditions are recursive; all subtrees under the specific
 * path prefix are counted.
 *
 * Generated from protobuf message <code>google.cloud.runtimeconfig.v1beta1.EndCondition.Cardinality</code>
 */
class EndCondition_Cardinality extends \Google\Protobuf\Internal\Message
{
    /**
     * The root of the variable subtree to monitor. For example, `/foo`.
     *
     * Generated from protobuf field <code>string path = 1;</code>
     */
    private $path = '';
    /**
     * The number variables under the `path` that must exist to meet this
     * condition. Defaults to 1 if not specified.
     *
     * Generated from protobuf field <code>int32 number = 2;</code>
     */
    private $number = 0;

    public function __construct() {
        \GPBMetadata\Google\Cloud\Runtimeconfig\V1Beta1\Resources::initOnce();
        parent::__construct();
    }

    /**
     * The root of the variable subtree to monitor. For example, `/foo`.
     *
     * Generated from protobuf field <code>string path = 1;</code>
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * The root of the variable subtree to monitor. For example, `/foo`.
     *
     * Generated from protobuf field <code>string path = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->path = $var;

        return $this;
    }

    /**
     * The number variables under the `path` that must exist to meet this
     * condition. Defaults to 1 if not specified.
     *
     * Generated from protobuf field <code>int32 number = 2;</code>
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * The number variables under the `path` that must exist to meet this
     * condition. Defaults to 1 if not specified.
     *
     * Generated from protobuf field <code>int32 number = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setNumber($var)
    {
        GPBUtil::checkInt32($var);
        $this->number = $var;

        return $this;
    }

}

