<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ml/v1/model_service.proto

namespace Google\Cloud\Ml\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a version of the model.
 * Each version is a trained model deployed in the cloud, ready to handle
 * prediction requests. A model can have multiple versions. You can get
 * information about all of the versions of a given model by calling
 * [projects.models.versions.list](/ml/reference/rest/v1/projects.models.versions/list).
 *
 * Generated from protobuf message <code>google.cloud.ml.v1.Version</code>
 */
class Version extends \Google\Protobuf\Internal\Message
{
    /**
     * Required.The name specified for the version when it was created.
     * The version name must be unique within the model it is created in.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Optional. The description specified for the version when it was created.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * Output only. If true, this version will be used to handle prediction
     * requests that do not specify a version.
     * You can change the default version by calling
     * [projects.methods.versions.setDefault](/ml/reference/rest/v1/projects.models.versions/setDefault).
     *
     * Generated from protobuf field <code>bool is_default = 3;</code>
     */
    private $is_default = false;
    /**
     * Required. The Google Cloud Storage location of the trained model used to
     * create the version. See the
     * [overview of model deployment](/ml/docs/concepts/deployment-overview) for
     * more informaiton.
     * When passing Version to
     * [projects.models.versions.create](/ml/reference/rest/v1/projects.models.versions/create)
     * the model service uses the specified location as the source of the model.
     * Once deployed, the model version is hosted by the prediction service, so
     * this location is useful only as a historical record.
     *
     * Generated from protobuf field <code>string deployment_uri = 4;</code>
     */
    private $deployment_uri = '';
    /**
     * Output only. The time the version was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    private $create_time = null;
    /**
     * Output only. The time the version was last used for prediction.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_use_time = 6;</code>
     */
    private $last_use_time = null;
    /**
     * Optional. The Google Cloud ML runtime version to use for this deployment.
     * If not set, Google Cloud ML will choose a version.
     *
     * Generated from protobuf field <code>string runtime_version = 8;</code>
     */
    private $runtime_version = '';
    /**
     * Optional. Manually select the number of nodes to use for serving the
     * model. If unset (i.e., by default), the number of nodes used to serve
     * the model automatically scales with traffic. However, care should be
     * taken to ramp up traffic according to the model's ability to scale. If
     * your model needs to handle bursts of traffic beyond it's ability to
     * scale, it is recommended you set this field appropriately.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.ManualScaling manual_scaling = 9;</code>
     */
    private $manual_scaling = null;

    public function __construct() {
        \GPBMetadata\Google\Cloud\Ml\V1\ModelService::initOnce();
        parent::__construct();
    }

    /**
     * Required.The name specified for the version when it was created.
     * The version name must be unique within the model it is created in.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required.The name specified for the version when it was created.
     * The version name must be unique within the model it is created in.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The description specified for the version when it was created.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. The description specified for the version when it was created.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. If true, this version will be used to handle prediction
     * requests that do not specify a version.
     * You can change the default version by calling
     * [projects.methods.versions.setDefault](/ml/reference/rest/v1/projects.models.versions/setDefault).
     *
     * Generated from protobuf field <code>bool is_default = 3;</code>
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->is_default;
    }

    /**
     * Output only. If true, this version will be used to handle prediction
     * requests that do not specify a version.
     * You can change the default version by calling
     * [projects.methods.versions.setDefault](/ml/reference/rest/v1/projects.models.versions/setDefault).
     *
     * Generated from protobuf field <code>bool is_default = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsDefault($var)
    {
        GPBUtil::checkBool($var);
        $this->is_default = $var;

        return $this;
    }

    /**
     * Required. The Google Cloud Storage location of the trained model used to
     * create the version. See the
     * [overview of model deployment](/ml/docs/concepts/deployment-overview) for
     * more informaiton.
     * When passing Version to
     * [projects.models.versions.create](/ml/reference/rest/v1/projects.models.versions/create)
     * the model service uses the specified location as the source of the model.
     * Once deployed, the model version is hosted by the prediction service, so
     * this location is useful only as a historical record.
     *
     * Generated from protobuf field <code>string deployment_uri = 4;</code>
     * @return string
     */
    public function getDeploymentUri()
    {
        return $this->deployment_uri;
    }

    /**
     * Required. The Google Cloud Storage location of the trained model used to
     * create the version. See the
     * [overview of model deployment](/ml/docs/concepts/deployment-overview) for
     * more informaiton.
     * When passing Version to
     * [projects.models.versions.create](/ml/reference/rest/v1/projects.models.versions/create)
     * the model service uses the specified location as the source of the model.
     * Once deployed, the model version is hosted by the prediction service, so
     * this location is useful only as a historical record.
     *
     * Generated from protobuf field <code>string deployment_uri = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDeploymentUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->deployment_uri = $var;

        return $this;
    }

    /**
     * Output only. The time the version was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    /**
     * Output only. The time the version was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time the version was last used for prediction.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_use_time = 6;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastUseTime()
    {
        return $this->last_use_time;
    }

    /**
     * Output only. The time the version was last used for prediction.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_use_time = 6;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastUseTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_use_time = $var;

        return $this;
    }

    /**
     * Optional. The Google Cloud ML runtime version to use for this deployment.
     * If not set, Google Cloud ML will choose a version.
     *
     * Generated from protobuf field <code>string runtime_version = 8;</code>
     * @return string
     */
    public function getRuntimeVersion()
    {
        return $this->runtime_version;
    }

    /**
     * Optional. The Google Cloud ML runtime version to use for this deployment.
     * If not set, Google Cloud ML will choose a version.
     *
     * Generated from protobuf field <code>string runtime_version = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setRuntimeVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime_version = $var;

        return $this;
    }

    /**
     * Optional. Manually select the number of nodes to use for serving the
     * model. If unset (i.e., by default), the number of nodes used to serve
     * the model automatically scales with traffic. However, care should be
     * taken to ramp up traffic according to the model's ability to scale. If
     * your model needs to handle bursts of traffic beyond it's ability to
     * scale, it is recommended you set this field appropriately.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.ManualScaling manual_scaling = 9;</code>
     * @return \Google\Cloud\Ml\V1\ManualScaling
     */
    public function getManualScaling()
    {
        return $this->manual_scaling;
    }

    /**
     * Optional. Manually select the number of nodes to use for serving the
     * model. If unset (i.e., by default), the number of nodes used to serve
     * the model automatically scales with traffic. However, care should be
     * taken to ramp up traffic according to the model's ability to scale. If
     * your model needs to handle bursts of traffic beyond it's ability to
     * scale, it is recommended you set this field appropriately.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.ManualScaling manual_scaling = 9;</code>
     * @param \Google\Cloud\Ml\V1\ManualScaling $var
     * @return $this
     */
    public function setManualScaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ml\V1\ManualScaling::class);
        $this->manual_scaling = $var;

        return $this;
    }

}

