<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v1/bigtable_data.proto

namespace Google\Bigtable\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Takes a row as input and produces an alternate view of the row based on
 * specified rules. For example, a RowFilter might trim down a row to include
 * just the cells from columns matching a given regular expression, or might
 * return all the cells of a row but not their values. More complicated filters
 * can be composed out of these components to express requests such as, "within
 * every column of a particular family, give just the two most recent cells
 * which are older than timestamp X."
 * There are two broad categories of RowFilters (true filters and transformers),
 * as well as two ways to compose simple filters into more complex ones
 * (chains and interleaves). They work as follows:
 * * True filters alter the input row by excluding some of its cells wholesale
 * from the output row. An example of a true filter is the "value_regex_filter",
 * which excludes cells whose values don't match the specified pattern. All
 * regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
 * in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
 * important point to keep in mind is that RE2(.) is equivalent by default to
 * RE2([^\n]), meaning that it does not match newlines. When attempting to match
 * an arbitrary byte, you should therefore use the escape sequence '\C', which
 * may need to be further escaped as '\\C' in your client language.
 * * Transformers alter the input row by changing the values of some of its
 * cells in the output, without excluding them completely. Currently, the only
 * supported transformer is the "strip_value_transformer", which replaces every
 * cell's value with the empty string.
 * * Chains and interleaves are described in more detail in the
 * RowFilter.Chain and RowFilter.Interleave documentation.
 * The total serialized size of a RowFilter message must not
 * exceed 4096 bytes, and RowFilters may not be nested within each other
 * (in Chains or Interleaves) to a depth of more than 20.
 *
 * Generated from protobuf message <code>google.bigtable.v1.RowFilter</code>
 */
class RowFilter extends \Google\Protobuf\Internal\Message
{
    protected $filter;

    public function __construct() {
        \GPBMetadata\Google\Bigtable\V1\BigtableData::initOnce();
        parent::__construct();
    }

    /**
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter.Chain chain = 1;</code>
     * @return \Google\Bigtable\V1\RowFilter_Chain
     */
    public function getChain()
    {
        return $this->readOneof(1);
    }

    /**
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter.Chain chain = 1;</code>
     * @param \Google\Bigtable\V1\RowFilter_Chain $var
     * @return $this
     */
    public function setChain($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\RowFilter_Chain::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter.Interleave interleave = 2;</code>
     * @return \Google\Bigtable\V1\RowFilter_Interleave
     */
    public function getInterleave()
    {
        return $this->readOneof(2);
    }

    /**
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter.Interleave interleave = 2;</code>
     * @param \Google\Bigtable\V1\RowFilter_Interleave $var
     * @return $this
     */
    public function setInterleave($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\RowFilter_Interleave::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter.Condition condition = 3;</code>
     * @return \Google\Bigtable\V1\RowFilter_Condition
     */
    public function getCondition()
    {
        return $this->readOneof(3);
    }

    /**
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter.Condition condition = 3;</code>
     * @param \Google\Bigtable\V1\RowFilter_Condition $var
     * @return $this
     */
    public function setCondition($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\RowFilter_Condition::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * ADVANCED USE ONLY.
     * Hook for introspection into the RowFilter. Outputs all cells directly to
     * the output of the read rather than to any parent filter. Consider the
     * following example:
     * Chain(
     *   FamilyRegex("A"),
     *   Interleave(
     *     All(),
     *     Chain(Label("foo"), Sink())
     *   ),
     *   QualifierRegex("B")
     * )
     *                         A,A,1,w
     *                         A,B,2,x
     *                         B,B,4,z
     *                            |
     *                     FamilyRegex("A")
     *                            |
     *                         A,A,1,w
     *                         A,B,2,x
     *                            |
     *               +------------+-------------+
     *               |                          |
     *             All()                    Label(foo)
     *               |                          |
     *            A,A,1,w              A,A,1,w,labels:[foo]
     *            A,B,2,x              A,B,2,x,labels:[foo]
     *               |                          |
     *               |                        Sink() --------------+
     *               |                          |                  |
     *               +------------+      x------+          A,A,1,w,labels:[foo]
     *                            |                        A,B,2,x,labels:[foo]
     *                         A,A,1,w                             |
     *                         A,B,2,x                             |
     *                            |                                |
     *                    QualifierRegex("B")                      |
     *                            |                                |
     *                         A,B,2,x                             |
     *                            |                                |
     *                            +--------------------------------+
     *                            |
     *                         A,A,1,w,labels:[foo]
     *                         A,B,2,x,labels:[foo]  // could be switched
     *                         A,B,2,x               // could be switched
     * Despite being excluded by the qualifier filter, a copy of every cell
     * that reaches the sink is present in the final result.
     * As with an [Interleave][google.bigtable.v1.RowFilter.Interleave],
     * duplicate cells are possible, and appear in an unspecified mutual order.
     * In this case we have a duplicate with column "A:B" and timestamp 2,
     * because one copy passed through the all filter while the other was
     * passed through the label and sink. Note that one copy has label "foo",
     * while the other does not.
     * Cannot be used within the `predicate_filter`, `true_filter`, or
     * `false_filter` of a [Condition][google.bigtable.v1.RowFilter.Condition].
     *
     * Generated from protobuf field <code>bool sink = 16;</code>
     * @return bool
     */
    public function getSink()
    {
        return $this->readOneof(16);
    }

    /**
     * ADVANCED USE ONLY.
     * Hook for introspection into the RowFilter. Outputs all cells directly to
     * the output of the read rather than to any parent filter. Consider the
     * following example:
     * Chain(
     *   FamilyRegex("A"),
     *   Interleave(
     *     All(),
     *     Chain(Label("foo"), Sink())
     *   ),
     *   QualifierRegex("B")
     * )
     *                         A,A,1,w
     *                         A,B,2,x
     *                         B,B,4,z
     *                            |
     *                     FamilyRegex("A")
     *                            |
     *                         A,A,1,w
     *                         A,B,2,x
     *                            |
     *               +------------+-------------+
     *               |                          |
     *             All()                    Label(foo)
     *               |                          |
     *            A,A,1,w              A,A,1,w,labels:[foo]
     *            A,B,2,x              A,B,2,x,labels:[foo]
     *               |                          |
     *               |                        Sink() --------------+
     *               |                          |                  |
     *               +------------+      x------+          A,A,1,w,labels:[foo]
     *                            |                        A,B,2,x,labels:[foo]
     *                         A,A,1,w                             |
     *                         A,B,2,x                             |
     *                            |                                |
     *                    QualifierRegex("B")                      |
     *                            |                                |
     *                         A,B,2,x                             |
     *                            |                                |
     *                            +--------------------------------+
     *                            |
     *                         A,A,1,w,labels:[foo]
     *                         A,B,2,x,labels:[foo]  // could be switched
     *                         A,B,2,x               // could be switched
     * Despite being excluded by the qualifier filter, a copy of every cell
     * that reaches the sink is present in the final result.
     * As with an [Interleave][google.bigtable.v1.RowFilter.Interleave],
     * duplicate cells are possible, and appear in an unspecified mutual order.
     * In this case we have a duplicate with column "A:B" and timestamp 2,
     * because one copy passed through the all filter while the other was
     * passed through the label and sink. Note that one copy has label "foo",
     * while the other does not.
     * Cannot be used within the `predicate_filter`, `true_filter`, or
     * `false_filter` of a [Condition][google.bigtable.v1.RowFilter.Condition].
     *
     * Generated from protobuf field <code>bool sink = 16;</code>
     * @param bool $var
     * @return $this
     */
    public function setSink($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * Matches all cells, regardless of input. Functionally equivalent to
     * leaving `filter` unset, but included for completeness.
     *
     * Generated from protobuf field <code>bool pass_all_filter = 17;</code>
     * @return bool
     */
    public function getPassAllFilter()
    {
        return $this->readOneof(17);
    }

    /**
     * Matches all cells, regardless of input. Functionally equivalent to
     * leaving `filter` unset, but included for completeness.
     *
     * Generated from protobuf field <code>bool pass_all_filter = 17;</code>
     * @param bool $var
     * @return $this
     */
    public function setPassAllFilter($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * Does not match any cells, regardless of input. Useful for temporarily
     * disabling just part of a filter.
     *
     * Generated from protobuf field <code>bool block_all_filter = 18;</code>
     * @return bool
     */
    public function getBlockAllFilter()
    {
        return $this->readOneof(18);
    }

    /**
     * Does not match any cells, regardless of input. Useful for temporarily
     * disabling just part of a filter.
     *
     * Generated from protobuf field <code>bool block_all_filter = 18;</code>
     * @param bool $var
     * @return $this
     */
    public function setBlockAllFilter($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(18, $var);

        return $this;
    }

    /**
     * Matches only cells from rows whose keys satisfy the given RE2 regex. In
     * other words, passes through the entire row when the key matches, and
     * otherwise produces an empty row.
     * Note that, since row keys can contain arbitrary bytes, the '\C' escape
     * sequence must be used if a true wildcard is desired. The '.' character
     * will not match the new line character '\n', which may be present in a
     * binary key.
     *
     * Generated from protobuf field <code>bytes row_key_regex_filter = 4;</code>
     * @return string
     */
    public function getRowKeyRegexFilter()
    {
        return $this->readOneof(4);
    }

    /**
     * Matches only cells from rows whose keys satisfy the given RE2 regex. In
     * other words, passes through the entire row when the key matches, and
     * otherwise produces an empty row.
     * Note that, since row keys can contain arbitrary bytes, the '\C' escape
     * sequence must be used if a true wildcard is desired. The '.' character
     * will not match the new line character '\n', which may be present in a
     * binary key.
     *
     * Generated from protobuf field <code>bytes row_key_regex_filter = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setRowKeyRegexFilter($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Matches all cells from a row with probability p, and matches no cells
     * from the row with probability 1-p.
     *
     * Generated from protobuf field <code>double row_sample_filter = 14;</code>
     * @return float
     */
    public function getRowSampleFilter()
    {
        return $this->readOneof(14);
    }

    /**
     * Matches all cells from a row with probability p, and matches no cells
     * from the row with probability 1-p.
     *
     * Generated from protobuf field <code>double row_sample_filter = 14;</code>
     * @param float $var
     * @return $this
     */
    public function setRowSampleFilter($var)
    {
        GPBUtil::checkDouble($var);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * Matches only cells from columns whose families satisfy the given RE2
     * regex. For technical reasons, the regex must not contain the ':'
     * character, even if it is not being used as a literal.
     * Note that, since column families cannot contain the new line character
     * '\n', it is sufficient to use '.' as a full wildcard when matching
     * column family names.
     *
     * Generated from protobuf field <code>string family_name_regex_filter = 5;</code>
     * @return string
     */
    public function getFamilyNameRegexFilter()
    {
        return $this->readOneof(5);
    }

    /**
     * Matches only cells from columns whose families satisfy the given RE2
     * regex. For technical reasons, the regex must not contain the ':'
     * character, even if it is not being used as a literal.
     * Note that, since column families cannot contain the new line character
     * '\n', it is sufficient to use '.' as a full wildcard when matching
     * column family names.
     *
     * Generated from protobuf field <code>string family_name_regex_filter = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setFamilyNameRegexFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Matches only cells from columns whose qualifiers satisfy the given RE2
     * regex.
     * Note that, since column qualifiers can contain arbitrary bytes, the '\C'
     * escape sequence must be used if a true wildcard is desired. The '.'
     * character will not match the new line character '\n', which may be
     * present in a binary qualifier.
     *
     * Generated from protobuf field <code>bytes column_qualifier_regex_filter = 6;</code>
     * @return string
     */
    public function getColumnQualifierRegexFilter()
    {
        return $this->readOneof(6);
    }

    /**
     * Matches only cells from columns whose qualifiers satisfy the given RE2
     * regex.
     * Note that, since column qualifiers can contain arbitrary bytes, the '\C'
     * escape sequence must be used if a true wildcard is desired. The '.'
     * character will not match the new line character '\n', which may be
     * present in a binary qualifier.
     *
     * Generated from protobuf field <code>bytes column_qualifier_regex_filter = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setColumnQualifierRegexFilter($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Matches only cells from columns within the given range.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.ColumnRange column_range_filter = 7;</code>
     * @return \Google\Bigtable\V1\ColumnRange
     */
    public function getColumnRangeFilter()
    {
        return $this->readOneof(7);
    }

    /**
     * Matches only cells from columns within the given range.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.ColumnRange column_range_filter = 7;</code>
     * @param \Google\Bigtable\V1\ColumnRange $var
     * @return $this
     */
    public function setColumnRangeFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\ColumnRange::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Matches only cells with timestamps within the given range.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.TimestampRange timestamp_range_filter = 8;</code>
     * @return \Google\Bigtable\V1\TimestampRange
     */
    public function getTimestampRangeFilter()
    {
        return $this->readOneof(8);
    }

    /**
     * Matches only cells with timestamps within the given range.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.TimestampRange timestamp_range_filter = 8;</code>
     * @param \Google\Bigtable\V1\TimestampRange $var
     * @return $this
     */
    public function setTimestampRangeFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\TimestampRange::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Matches only cells with values that satisfy the given regular expression.
     * Note that, since cell values can contain arbitrary bytes, the '\C' escape
     * sequence must be used if a true wildcard is desired. The '.' character
     * will not match the new line character '\n', which may be present in a
     * binary value.
     *
     * Generated from protobuf field <code>bytes value_regex_filter = 9;</code>
     * @return string
     */
    public function getValueRegexFilter()
    {
        return $this->readOneof(9);
    }

    /**
     * Matches only cells with values that satisfy the given regular expression.
     * Note that, since cell values can contain arbitrary bytes, the '\C' escape
     * sequence must be used if a true wildcard is desired. The '.' character
     * will not match the new line character '\n', which may be present in a
     * binary value.
     *
     * Generated from protobuf field <code>bytes value_regex_filter = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setValueRegexFilter($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Matches only cells with values that fall within the given range.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.ValueRange value_range_filter = 15;</code>
     * @return \Google\Bigtable\V1\ValueRange
     */
    public function getValueRangeFilter()
    {
        return $this->readOneof(15);
    }

    /**
     * Matches only cells with values that fall within the given range.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.ValueRange value_range_filter = 15;</code>
     * @param \Google\Bigtable\V1\ValueRange $var
     * @return $this
     */
    public function setValueRangeFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\ValueRange::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * Skips the first N cells of each row, matching all subsequent cells.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     *
     * Generated from protobuf field <code>int32 cells_per_row_offset_filter = 10;</code>
     * @return int
     */
    public function getCellsPerRowOffsetFilter()
    {
        return $this->readOneof(10);
    }

    /**
     * Skips the first N cells of each row, matching all subsequent cells.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     *
     * Generated from protobuf field <code>int32 cells_per_row_offset_filter = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setCellsPerRowOffsetFilter($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Matches only the first N cells of each row.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     *
     * Generated from protobuf field <code>int32 cells_per_row_limit_filter = 11;</code>
     * @return int
     */
    public function getCellsPerRowLimitFilter()
    {
        return $this->readOneof(11);
    }

    /**
     * Matches only the first N cells of each row.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     *
     * Generated from protobuf field <code>int32 cells_per_row_limit_filter = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setCellsPerRowLimitFilter($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Matches only the most recent N cells within each column. For example,
     * if N=2, this filter would match column "foo:bar" at timestamps 10 and 9,
     * skip all earlier cells in "foo:bar", and then begin matching again in
     * column "foo:bar2".
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     *
     * Generated from protobuf field <code>int32 cells_per_column_limit_filter = 12;</code>
     * @return int
     */
    public function getCellsPerColumnLimitFilter()
    {
        return $this->readOneof(12);
    }

    /**
     * Matches only the most recent N cells within each column. For example,
     * if N=2, this filter would match column "foo:bar" at timestamps 10 and 9,
     * skip all earlier cells in "foo:bar", and then begin matching again in
     * column "foo:bar2".
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     *
     * Generated from protobuf field <code>int32 cells_per_column_limit_filter = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setCellsPerColumnLimitFilter($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Replaces each cell's value with the empty string.
     *
     * Generated from protobuf field <code>bool strip_value_transformer = 13;</code>
     * @return bool
     */
    public function getStripValueTransformer()
    {
        return $this->readOneof(13);
    }

    /**
     * Replaces each cell's value with the empty string.
     *
     * Generated from protobuf field <code>bool strip_value_transformer = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setStripValueTransformer($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Applies the given label to all cells in the output row. This allows
     * the client to determine which results were produced from which part of
     * the filter.
     * Values must be at most 15 characters in length, and match the RE2
     * pattern [a-z0-9\\-]+
     * Due to a technical limitation, it is not currently possible to apply
     * multiple labels to a cell. As a result, a Chain may have no more than
     * one sub-filter which contains a apply_label_transformer. It is okay for
     * an Interleave to contain multiple apply_label_transformers, as they will
     * be applied to separate copies of the input. This may be relaxed in the
     * future.
     *
     * Generated from protobuf field <code>string apply_label_transformer = 19;</code>
     * @return string
     */
    public function getApplyLabelTransformer()
    {
        return $this->readOneof(19);
    }

    /**
     * Applies the given label to all cells in the output row. This allows
     * the client to determine which results were produced from which part of
     * the filter.
     * Values must be at most 15 characters in length, and match the RE2
     * pattern [a-z0-9\\-]+
     * Due to a technical limitation, it is not currently possible to apply
     * multiple labels to a cell. As a result, a Chain may have no more than
     * one sub-filter which contains a apply_label_transformer. It is okay for
     * an Interleave to contain multiple apply_label_transformers, as they will
     * be applied to separate copies of the input. This may be relaxed in the
     * future.
     *
     * Generated from protobuf field <code>string apply_label_transformer = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setApplyLabelTransformer($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(19, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getFilter()
    {
        return $this->whichOneof("filter");
    }

}

